# PhotoAid - AI Passport Photo Creator

**Single-tool passport photo creator with email delivery. No storage.**

## Features

- ✅ Single passport photo tool (like your screenshot)
- ✅ Dark theme matching your design
- ✅ No payment (auto-deliver)
- ✅ No storage - process and delete immediately
- ✅ Email delivery with attachments
- ✅ Step-by-step processing UI

## Quick Start

```bash
cd public
php -S localhost:8000
```

Open: http://localhost:8000

## Configuration

Edit `includes/config.php`:

### API Keys (Required: at least Remove.bg)

```php
// Remove.bg - Background removal (REQUIRED)
define('REMOVEBG_API_KEY', 'your_key');

// Clipdrop - 4K upscaling (optional)
define('CLIPDROP_API_KEY', 'your_key');

// AWS - Face detection (optional)
define('AWS_ACCESS_KEY', 'your_key');
define('AWS_SECRET_KEY', 'your_secret');
```

### Email Settings

```php
// Option 1: Use PHP mail() - simplest
define('USE_PHP_MAIL', true);
define('SMTP_FROM', 'noreply@yourdomain.com');
define('SMTP_FROM_NAME', 'PhotoAid');

// Option 2: Use SMTP
define('USE_PHP_MAIL', false);
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USER', 'your@gmail.com');
define('SMTP_PASS', 'your-app-password');
```

## How It Works

1. User uploads photo + enters email
2. System processes:
   - Removes background (Remove.bg)
   - Detects face (AWS Rekognition)
   - Creates passport photo
   - Creates print sheet
3. Emails photos as attachments
4. **Deletes all files immediately** - nothing stored

## File Structure

```
photoaid-final/
├── public/
│   ├── index.php      # Main UI
│   └── process.php    # Processing endpoint
├── includes/
│   ├── config.php     # Configuration
│   ├── AIServices.php # API integrations
│   ├── ImageProcessor.php
│   └── EmailService.php
└── temp/              # Temporary files (auto-cleaned)
```

## Supported Documents

- 🇬🇧 UK Passport (35×45mm)
- 🇬🇧 UK Driving Licence (35×45mm)
- 🇬🇧 UK Visa (35×45mm)
- 🇺🇸 US Passport (2×2 inch)
- 🇪🇺 EU/Schengen (35×45mm)
- 🇨🇦 Canadian Passport (50×70mm)

## Cost

~$0.15-0.20 per photo (Remove.bg only)

With all features: ~$0.22 per photo

## Security

- Files deleted immediately after email
- No user data stored
- Temp files cleaned every 5 minutes
