<?php
/**
 * Get session data including compliance results
 */

header('Content-Type: application/json');

require_once __DIR__ . '/../includes/config.php';

$sessionId = $_GET['session'] ?? '';

if (!$sessionId || !preg_match('/^sess_[a-f0-9.]+$/i', $sessionId)) {
    echo json_encode(['error' => 'Invalid session']);
    exit;
}

$sessionFile = TEMP_DIR . $sessionId . '_session.json';

if (!file_exists($sessionFile)) {
    echo json_encode(['error' => 'Session not found']);
    exit;
}

$data = json_decode(file_get_contents($sessionFile), true);

if (!$data) {
    echo json_encode(['error' => 'Invalid session data']);
    exit;
}

echo json_encode([
    'session_id' => $data['session_id'] ?? $sessionId,
    'document_type' => $data['document_type'] ?? 'uk_passport',
    'spec_name' => $data['spec_name'] ?? 'UK Passport',
    'compliance' => $data['compliance'] ?? null,
    'created' => $data['created'] ?? time()
]);
