<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Photos Sent - PhotoAid</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        :root {
            --background: hsl(0 0% 100%);
            --foreground: hsl(220 20% 10%);
            --primary: hsl(24 95% 53%);
            --muted: hsl(220 14% 96%);
            --muted-foreground: hsl(220 10% 45%);
            --border: hsl(220 14% 90%);
            --gradient-primary: linear-gradient(135deg, hsl(38 92% 50%), hsl(24 95% 53%), hsl(12 90% 60%));
            --shadow-glow: 0 0 40px -10px hsla(24, 95%, 53%, 0.4);
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Inter', system-ui, sans-serif;
            background: var(--background);
            color: var(--foreground);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 24px;
        }
        
        .gradient-text {
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .card {
            background: white;
            border: 1px solid var(--border);
            border-radius: 24px;
            padding: 48px;
            max-width: 480px;
            text-align: center;
            box-shadow: 0 20px 40px -12px hsla(220, 20%, 10%, 0.1);
        }
        
        .success-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: hsla(142, 76%, 36%, 0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 24px;
        }
        .success-icon svg { width: 40px; height: 40px; color: hsl(142, 76%, 36%); }
        
        h1 {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 8px;
        }
        
        .email {
            color: var(--primary);
            font-weight: 600;
        }
        
        p {
            color: var(--muted-foreground);
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 32px;
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-size: 16px;
            font-weight: 600;
            padding: 16px 32px;
            border-radius: 16px;
            border: none;
            cursor: pointer;
            text-decoration: none;
            background: var(--gradient-primary);
            color: white;
            box-shadow: var(--shadow-glow);
            transition: transform 0.2s;
        }
        .btn:hover { transform: translateY(-2px); }
        .btn svg { width: 20px; height: 20px; }
        
        .logo {
            margin-top: 48px;
            font-size: 18px;
            font-weight: 700;
            color: var(--muted-foreground);
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="success-icon">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M22 2L11 13"/>
                <path d="M22 2l-7 20-4-9-9-4 20-7z"/>
            </svg>
        </div>
        <h1>Photos sent!</h1>
        <p>
            Your passport photos have been sent to<br>
            <span class="email" id="emailDisplay"></span>
        </p>
        <p style="margin-top:-16px;">
            Check your inbox (and spam folder) for your photos. They should arrive within a few minutes.
        </p>
        <a href="index.php" class="btn">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/></svg>
            Create Another Photo
        </a>
    </div>
    <div class="logo">photo<span class="gradient-text">Aid</span></div>

    <script>
        const params = new URLSearchParams(window.location.search);
        const email = params.get('email') || 'your email';
        document.getElementById('emailDisplay').textContent = email;
    </script>
</body>
</html>
